(function ($) {
    'use strict';

    window.DSSuit = {};

    window.DSSuit.get_responsive_css = function (props, property, css_selector, css_property, important) {
        var css = [];

        const responsive_active = props[property + "_last_edited"] && props[property + "_last_edited"].startsWith("on");

        var declaration_desktop = "";
        var declaration_tablet = "";
        var declaration_phone = "";
        const is_important = important ? "!important" : "";

        switch (css_property) {
            case "margin":
            case "padding":
                if (props[property]) {
                    var values = props[property].split("|");
                    declaration_desktop = `${css_property}-top: ${values[0]}${is_important};
                                           ${css_property}-right: ${values[1]}${is_important};
                                           ${css_property}-bottom: ${values[2]}${is_important};
                                           ${css_property}-left: ${values[3]}${is_important};`;
                }

                if (responsive_active && props[property + "_tablet"]) {
                    var values = props[property + "_tablet"].split("|");
                    declaration_tablet = `${css_property}-top: ${values[0]}${is_important};
                                          ${css_property}-right: ${values[1]}${is_important};
                                          ${css_property}-bottom: ${values[2]}${is_important};
                                          ${css_property}-left: ${values[3]}${is_important};`;
                }

                if (responsive_active && props[property + "_phone"]) {
                    var values = props[property + "_phone"].split("|");
                    declaration_phone = `${css_property}-top: ${values[0]}${is_important};
                                         ${css_property}-right: ${values[1]}${is_important};
                                         ${css_property}-bottom: ${values[2]}${is_important};
                                         ${css_property}-left: ${values[3]}${is_important};`;
                }
                break;
            default: //Default is applied for values like height, color etc.
                declaration_desktop = `${css_property}: ${props[property]}${is_important};`;
                declaration_tablet = `${css_property}: ${props[property + "_tablet"]}${is_important};`;
                declaration_phone = `${css_property}: ${props[property + "_phone"]}${is_important};`;
        }

        css.push({
            selector: css_selector,
            declaration: declaration_desktop,
        });

        if (props[property + "_tablet"] && responsive_active) {
            css.push({
                selector: css_selector,
                declaration: declaration_tablet,
                device: 'tablet',
            });
        }

        if (props[property + "_phone"] && responsive_active) {
            css.push({
                selector: css_selector,
                declaration: declaration_phone,
                device: 'phone',
            });
        }


        return css;
    }

    window.DSSuit.get_border_css = function(props, suffix, border_radii_selector, border_styles_selector) {
        var css = [];

        console.log("Props isn", props);

        const border_radii = props["border_radii_" + suffix] ? props["border_radii_" + suffix].split("|") : [];

        css.push({
            selector: border_radii_selector,
            declaration: `border-top-left-radius: ${border_radii[1]}; border-top-right-radius: ${border_radii[2]}; border-bottom-right-radius: ${border_radii[3]}; border-bottom-left-radius: ${border_radii[4]};`,
        });

        //Border styles
        const width_top = props["border_width_top_" + suffix] || props["border_width_all_" + suffix];
        const width_right = props["border_width_right_" + suffix] || props["border_width_all_" + suffix];
        const width_bottom = props["border_width_bottom_" + suffix] || props["border_width_all_" + suffix];
        const width_left = props["border_width_left_" + suffix] || props["border_width_all_" + suffix];

        css.push({
            selector: border_styles_selector,
            declaration: `border-top-width: ${width_top}; border-right-width: ${width_right}; border-bottom-width: ${width_bottom}; border-left-width: ${width_left};`,
        });
        
        const style_top = props["border_style_top_" + suffix] || props["border_style_all_" + suffix];
        const style_right = props["border_style_right_" + suffix] || props["border_style_all_" + suffix];
        const style_bottom = props["border_style_bottom_" + suffix] || props["border_style_all_" + suffix];
        const style_left = props["border_style_left_" + suffix] || props["border_style_all_" + suffix];
        
        css.push({
            selector: border_styles_selector,
            declaration: `border-top-style: ${style_top}; border-right-style: ${style_right}; border-bottom-style: ${style_bottom}; border-left-style: ${style_left};`,
        });

        const color_top = props["border_color_top_" + suffix] || props["border_color_all_" + suffix];
        const color_right = props["border_color_right_" + suffix] || props["border_color_all_" + suffix];
        const color_bottom = props["border_color_bottom_" + suffix] || props["border_color_all_" + suffix];
        const color_left = props["border_color_left_" + suffix] || props["border_color_all_" + suffix];
        
        css.push({
            selector: border_styles_selector,
            declaration: `border-top-color: ${color_top}; border-right-color: ${color_right}; border-bottom-color: ${color_bottom}; border-left-color: ${color_left};`,
        });

        return css;
    }

    $.fn.dss_hover_link_double_tap = function (params) {

        if (!('ontouchstart' in window) &&
            !navigator.msMaxTouchPoints &&
            !navigator.userAgent.toLowerCase().match(/windows phone os 7/i)) return false;

        this.each(function () {
            var curItem = false;

            $(this).on('click', function (e) {
                var item = $(this);
                if (item[0] != curItem[0]) {
                    e.preventDefault();
                    curItem = item;
                }
            });

            $(document).on('click touchstart MSPointerDown', function (e) {
                var resetItem = true,
                    parents = $(e.target).parents();

                if ($(e.target)[0] == curItem[0]) {
                    return;
                }

                for (var i = 0; i < parents.length; i++) {
                    if (parents[i] == curItem[0]) {
                        resetItem = false;
                    }
                }

                if (resetItem)
                    curItem = false;
            });
        });
        return this;
    };

    $.fn.dss_masonry_gallery = function (params) {
        var grid = this;
        var masonry = $(grid).masonry({
            // set itemSelector so .grid-sizer is not used in layout
            itemSelector: '.grid-item',
            // use element for option
            columnWidth: '.grid-sizer',
            percentPosition: true,
            gutter: '.gutter-sizer',
        });

        masonry.imagesLoaded().progress(function () {
            masonry.masonry('layout');
        });

        $(grid).magnificPopup( {
            delegate: '.et_pb_gallery_image a',
            type: 'image',
            removalDelay: 500,
            gallery: {
                enabled: true,
                navigateByImgClick: true
            },
            mainClass: 'mfp-fade',
            zoom: {
                enabled: true,//! et_pb_custom.is_builder_plugin_used,
                duration: 500,
                opener: function(element) {
                    return element.find('img');
                }
            },
            autoFocusLast: false
        } );

        // prevent attaching of any further actions on click
        $(grid).find( 'a' ).unbind( 'click' );
    };

    $(document).ready(function () {
        $(".dss_bucket .dss_bucket_link").dss_hover_link_double_tap();
        $(".dss_masonry_gallery .grid").dss_masonry_gallery();
    });

})(jQuery);
