<?php

class DSS_Masonry_Layout extends ET_Builder_Module
{

    public $slug = 'dss_masonry_gallery';
    public $vb_support = 'on';

    protected $module_credits = array(
        'module_uri' => 'https://divi-sensei.com/suit',
        'author' => 'Divi Sensei',
        'author_uri' => 'https://divi-sensei.com',
    );

    public function init()
    {
        $this->name = esc_html__('Masonry Gallery', 'ds-suit');
        $this->settings_modal_toggles = [
            'general' => [
                'toggles' => [
                    'images' => esc_html__('Images', 'ds-suit'),
                ],
            ],
            'advanced' => [
                'toggles' => [
                    'grid' => esc_html__('Grid', 'ds-suit'),
                    'grid_items' => esc_html__('Grid Items', 'ds-suit'),
                ],
            ],
        ];
    }

    public function get_fields()
    {
        $fields = [];

        $fields["images"] = [
            'label' => esc_html__('Gallery Images', 'ds-suit'),
            'type' => 'upload-gallery',
            'option_category' => 'basic_option',
            'toggle_slug' => 'images',
        ];

        $fields["columns"] = [
            'label' => esc_html__('Columns', 'ds-suit'),
            'type' => 'range',
            'option_category' => 'basic_option',
            'toggle_slug' => 'grid',
            'tab_slug' => 'advanced',
            'default' => '4',
            'range_settings' => array(
                'min' => '1',
                'max' => '10',
                'step' => '1',
            ),
            'mobile_options' => true,
            'unitless' => true,
        ];

        $fields["gutter"] = [
            'label' => esc_html__('Gutter', 'ds-suit'),
            'type' => 'range',
            'option_category' => 'basic_option',
            'toggle_slug' => 'grid',
            'tab_slug' => 'advanced',
            'default' => '10',
            'range_settings' => array(
                'min' => '0',
                'max' => '100',
                'step' => '1',
            ),
            'mobile_options' => true,
            'unitless' => true,
        ];

        return $fields;
    }

    public function get_advanced_fields_config()
    {

        $advanced_fields = [];

        $advanced_fields["text"] = false;
        $advanced_fields["text_shadow"] = false;
        $advanced_fields["fonts"] = false;

        $advanced_fields["borders"]["default"] = [
            'css' => [
                'main' => [
                    'border_radii' => "%%order_class%%",
                    'border_styles' => "%%order_class%%",
                ],
            ],
        ];

        $advanced_fields["borders"]["grid_item"] = [
            'label_prefix' => esc_html__('Grid Item', 'ds-suit'),
            'toggle_slug' => 'grid_items',
            'tab_slug' => 'advanced',
            'css' => [
                'main' => [
                    'border_radii' => "%%order_class%% .grid .grid-item.et_pb_gallery_image",
                    'border_styles' => "%%order_class%% .grid .grid-item.et_pb_gallery_image",
                ],
            ],
        ];

        return $advanced_fields;
    }

    public function render($attrs, $content = null, $render_slug)
    {
        $this->dss_apply_css($render_slug);

        $items = [];
        foreach (explode(",", $this->props["images"]) as $attachment_id) {
            $url = wp_get_attachment_image_src($attachment_id, "full")[0];
            $image_alt = get_post_meta($attachment_id, '_wp_attachment_image_alt', true);
            $image_title = get_the_title($attachment_id);
            $items[] = sprintf(
                '<div class="grid-item et_pb_gallery_image">
                    <a href="%1$s">
                        <img src="%1$s" alt="%2$s" title="%3$s"/>
                    </a>
                </div>',
                $url,
                $image_alt,
                $image_title
            );
        }

        return sprintf(
            '<div class="grid">
                <div class="grid-sizer"></div>
                <div class="gutter-sizer"></div>
                %1$s
             </div>',
            implode("", $items)
        );
    }

    public function dss_apply_css($render_slug)
    {

        $columns = $this->props["columns"];
        $columns_responsive_active = $this->props["columns_last_edited"] && strpos($this->props["columns_last_edited"], "on") == 0;
        $columns_tablet = $columns_responsive_active ? $this->props["columns_tablet"] : $columns;
        $columns_phone = $columns_responsive_active ? $this->props["columns_phone"] : $columns_tablet;

        $gutter = $this->props["gutter"];
        $gutter_responsive_active = $this->props["gutter_last_edited"] && strpos($this->props["gutter_last_edited"], "on") == 0;
        $gutter_tablet = $gutter_responsive_active ? $this->props["gutter_tablet"] : $gutter;
        $gutter_phone = $gutter_responsive_active ? $this->props["gutter_phone"] : $gutter_tablet;

        //Width of grid items
        \ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .grid-sizer, %%order_class%% .grid-item',
            'declaration' => "width: calc((100% - ({$columns} - 1) * {$gutter}px) / {$columns});",
        ]);

        \ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .grid-sizer, %%order_class%% .grid-item',
            'declaration' => "width: calc((100% - ({$columns_tablet} - 1) * {$gutter_tablet}px) / {$columns_tablet});",
            'media_query' => \ET_Builder_Element::get_media_query('max_width_980'),
        ]);

        \ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .grid-sizer, %%order_class%% .grid-item',
            'declaration' => "width: calc((100% - {($columns_phone} - 1) * {$gutter_phone}px) / {$columns_phone});",
            'media_query' => \ET_Builder_Element::get_media_query('max_width_767'),
        ]);

        //Gutter of grid items
        \ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .grid-item',
            'declaration' => "margin-bottom: {$gutter}px;",
        ]);

        \ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .grid-item',
            'declaration' => "margin-bottom: {$gutter_tablet}px;",
            'media_query' => \ET_Builder_Element::get_media_query('max_width_980'),
        ]);

        \ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .grid-item',
            'declaration' => "margin-bottom: {$gutter_phone}px;",
            'media_query' => \ET_Builder_Element::get_media_query('max_width_767'),
        ]);

        \ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .gutter-sizer',
            'declaration' => "width: {$gutter}px;",
        ]);

        \ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .gutter-sizer',
            'declaration' => "width: {$gutter_tablet}px;",
            'media_query' => \ET_Builder_Element::get_media_query('max_width_980'),
        ]);

        \ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .gutter-sizer',
            'declaration' => "width: {$gutter_phone}px;",
            'media_query' => \ET_Builder_Element::get_media_query('max_width_767'),
        ]);

        //Remove gutter from outer grid
        \ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .grid',
            'declaration' => "margin-bottom: -{$gutter}px;",
        ]);

        \ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .grid',
            'declaration' => "margin-bottom: -{$gutter_tablet}px;",
            'media_query' => \ET_Builder_Element::get_media_query('max_width_980'),
        ]);

        \ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .grid',
            'declaration' => "margin-bottom: -{$gutter_phone}px;",
            'media_query' => \ET_Builder_Element::get_media_query('max_width_767'),
        ]);
    }

}

new DSS_Masonry_Layout;
