// External Dependencies
import React from 'react';
import $ from 'jquery';
import { findDOMNode } from 'react-dom';

// Internal Dependencies
import AjaxComponent from './../base/AjaxComponent';
import './style.css';


class MasonryGallery extends AjaxComponent {

    static slug = 'dss_masonry_gallery';

    static css(props) {
        const additionalCss = [];

        const columns = props.columns;
        const columns_responsive_active = props.columns_last_edited && props.columns_last_edited.startsWith("on");
        const columns_tablet = columns_responsive_active ? props.columns_tablet : columns;
        const columns_phone = columns_responsive_active ? props.columns_phone : columns_tablet;
        
        const gutter = props.gutter;
        const gutter_responsive_active = props.gutter_last_edited && props.gutter_last_edited.startsWith("on");
        const gutter_tablet = gutter_responsive_active ? props.gutter_tablet : gutter;
        const gutter_phone = gutter_responsive_active ? props.gutter_phone : gutter_tablet;
        
        //Width of grid items
        additionalCss.push([{
            selector: '%%order_class%% .grid-sizer, %%order_class%% .grid-item',
            declaration: `width: calc((100% - ${(columns - 1) * gutter}px) / ${columns});`,
        }]);        
        
        additionalCss.push([{
            selector: '%%order_class%% .grid-sizer, %%order_class%% .grid-item',
            declaration: `width: calc((100% - ${(columns_tablet - 1) * gutter_tablet}px) / ${columns_tablet});`,
            device: 'tablet',
        }]);
        
        additionalCss.push([{
            selector: '%%order_class%% .grid-sizer, %%order_class%% .grid-item',         
            declaration: `width: calc((100% - ${(columns_phone - 1) * gutter_phone}px) / ${columns_phone});`,
            device: 'phone',
        }]);

        //Gutter of grid items
        additionalCss.push([{
            selector: '%%order_class%% .grid-item',
            declaration: `margin-bottom: ${gutter}px;`,
        }]);        
        
        additionalCss.push([{
            selector: '%%order_class%% .grid-item',
            declaration: `margin-bottom: ${gutter_tablet}px;`,
            device: 'tablet',
        }]);
        
        additionalCss.push([{
            selector: '%%order_class%% .grid-item',         
            declaration: `margin-bottom: ${gutter_phone}px;`,
            device: 'phone',
        }]);

        additionalCss.push([{
            selector: '%%order_class%% .gutter-sizer',
            declaration: `width: ${gutter}px;`,
        }]);        
        
        additionalCss.push([{
            selector: '%%order_class%% .gutter-sizer',
            declaration: `width: ${gutter_tablet}px;`,
            device: 'tablet',
        }]);
        
        additionalCss.push([{
            selector: '%%order_class%% .gutter-sizer',         
            declaration: `width: ${gutter_phone}px;`,
            device: 'phone',
        }]);
 
        //Remove gutter from outer grid
        additionalCss.push([{
            selector: '%%order_class%% .grid',
            declaration: `margin-bottom: -${gutter}px;`,
        }]);        
        
        additionalCss.push([{
            selector: '%%order_class%% .grid',
            declaration: `margin-bottom: -${gutter_tablet}px;`,
            device: 'tablet',
        }]);
        
        additionalCss.push([{
            selector: '%%order_class%% .grid',
            declaration: `margin-bottom: -${gutter_phone}px;`,
            device: 'phone',
        }]);

        //Border for Grid Items
        additionalCss.push(window.DSSuit.get_border_css(
            props, 
            "grid_item", 
            "%%order_class%% .grid .grid-item.et_pb_gallery_image", 
            "%%order_class%% .grid .grid-item.et_pb_gallery_image"
        ));

        return additionalCss;
    }

    componentDidUpdate(prevProps) {
        super.componentDidUpdate(prevProps)
        const grid = findDOMNode(this.refs.grid);
        if (!grid) return;       
        $(grid).dss_masonry_gallery();
    }

    _shouldReload(oldProps, newProps) {
        return oldProps.images !== newProps.images;
    }

    _reloadData(props) {
        return {
            action: 'dss_masonry_gallery',
            images: props.images,
            nonce: window.DsSuitBuilderData.nonces.dss_masonry_gallery
        };
    }

    render() {
        return super.render();
    }

    _render() {
        const orderClass = `${this.props.moduleInfo.type}_${this.props.moduleInfo.order}`;
        return (
            <div className="grid" ref="grid">
                <div className="grid-sizer"></div>
                <div className="gutter-sizer"></div>
                {
                    this.state.result.images.map((url, index) => {
                        return (
                            <div className="grid-item et_pb_gallery_image" key={`${orderClass}-${index}`}>
                                <a href={url}>
                                    <img src={url} alt={`${orderClass}-${index}`} />
                                    {/* <span className={overlay_classes} data-icon={data_icon}></span> */}
                                </a>
                            </div>
                        );
                    })
                }
            </div>
        );
    }
}

export default MasonryGallery;
