<?php

class DSS_DsSuit extends DiviExtension {

	/**
	 * The gettext domain for the extension's translations.
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $gettext_domain = 'ds-suit';

	/**
	 * The extension's WP Plugin name.
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $name = 'ds-suit';

	/**
	 * The extension's version
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $version = '1.0.0';

	/**
	 * DSS_DsSuit constructor.
	 *
	 * @param string $name
	 * @param array  $args
	 */
	public function __construct( $name = 'ds-suit', $args = array() ) {
		$this->plugin_dir     = plugin_dir_path( __FILE__ );
		$this->plugin_dir_url = plugin_dir_url( $this->plugin_dir );
		$this->_builder_js_data = array(
            'misc' => array(
                'site_url' => get_site_url(),
            ),
			'nonces' => array(
				'dss_bucket' => wp_create_nonce( 'dss_bucket' ),
				'dss_footer' => wp_create_nonce( 'dss_footer' ),
				'dss_get_post_meta' => wp_create_nonce( 'dss_get_post_meta' ),
				'dss_get_post_title' => wp_create_nonce( 'dss_get_post_title' ),
				'dss_get_post_excerpt' => wp_create_nonce( 'dss_get_post_excerpt' ),
				'dss_get_post_featured_image' => wp_create_nonce( 'dss_get_post_featured_image' ),
				'dss_masonry_gallery' => wp_create_nonce( 'dss_masonry_gallery' ),
			),
			'i10n' => array(
				'dss_post_excerpt' => array(
					'read more'    => esc_html__( 'Read More', 'ds-suit' ),
				),
			),
		);

		parent::__construct( $name, $args );
	}
}

new DSS_DsSuit;