<?php
namespace DiviSenseiSuit;

if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

/**
 * Class Settings
 *
 * @since 1.8.0
 */
class Settings extends Settings_Page
{
    const PAGE_ID = 'ds-suit';

    private $_tabs;

    /**
     * menu
     *
     * Adds the item to the menu
     *
     * @since 1.8.0
     *
     * @access public
     */

    public function menu()
    {
        $slug = 'ds-suit';
        $capability = 'manage_options';

        add_menu_page(
            __('Divi Sensei Suit', 'ds-suit'),
            __('Divi Sensei Suit', 'ds-suit'),
            $capability,
            $slug,
            [$this, 'render_page'],
            'data:image/svg+xml;base64,' . base64_encode('<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 226.8 226.8" width="20" height="20">
            <path fill="#eee" d="M105.9,49.9c0,0,3.3-14.5-9.5-15.3c-13-0.8-13.3,7.4-30.1,6.8c-13-0.5-21.3-7-26.3-7.5c4.5,5.5,15.5,17.5,35.6,16
                c11.6-0.9,16.7-5.3,19.8-5.5C99.6,44.2,102.4,45.9,105.9,49.9"/>
            <path fill="#eee" d="M120.9,49.9c0,0-3.3-14.5,9.5-15.3c13-0.8,13.3,7.4,30.1,6.8c13-0.5,21.3-7,26.3-7.5c-4.5,5.5-15.5,17.5-35.6,16
                c-11.6-0.9-16.7-5.3-19.8-5.5C127.1,44.2,124.4,45.9,120.9,49.9"/>
            <path fill="#eee" d="M102.2,78.8c0,0-28.1-13-39.8,15.5c-15.6,37.9,5,97,8,97.7c3,0.8-11.8-64.9,3-93c5.1-9.7,16-12.4,28.8-13
                C112,85.6,102.2,78.8,102.2,78.8"/>
            <path fill="#eee" d="M124.8,78.8c0,0,28.1-13,39.8,15.5c15.6,37.9-5,97-8,97.7c-3,0.8,11.8-64.9-3-93c-5.1-9.7-16-12.4-28.8-13
                C115.1,85.6,124.8,78.8,124.8,78.8"/>
            <path fill="#eee" d="M127.6,120.6c-0.4-14.2-11.1-13.9-14.1-13.7c-0.1-0.1,7-0.1-0.1-0.1c-3-0.3-13.8-0.5-14.2,13.7c-0.5,16,12.2,91.6,14.2,92.9
                c0,0,0-0.8,0-2.2c0,1.5,0,2.3,0,2.3C115.5,212.3,128.1,136.7,127.6,120.6"/>
            </svg>')
        );

        add_submenu_page(
            $slug,
            __('Settings', 'ds-suit'),
            __('Settings', 'ds-suit'),
            $capability,
            $slug,
            null
        );

        // add_submenu_page(
        //     $slug,
        //     __('Affiliation', 'ds-suit'),
        //     __('Affiliation', 'ds-suit'),
        //     $capability,
        //     'ds-suit-affiliation',
        //     [$this, 'affiliation_page']
        // );
    }

    // function affiliation_page(){
    //     $fs   = freemius( 2000 );

    //     $slug = $fs->get_slug();

    //     echo "Der slug ist " . $slug;
    //     print_r( $fs);

    // }

    /**
     * enqueue_scripts
     *
     * Enqueue styles and scripts
     *
     * @since 1.8.0
     *
     * @access public
     */

    public function enqueue_scripts()
    {
    }

    /**
     * Hooked into admin_init action
     *
     * @since 1.8.0
     *
     * @access public
     */

    public function init()
    {
        parent::init();
    }

    /**
     * Creates the tabs object
     *
     * @since 1.8.0
     *
     * @access protected
     */

    protected function create_page_tabs()
    {
        return $this->_tabs;
    }

    /**
     * Gets the settings sections
     *
     * @since 1.8.0
     *
     * @access public
     */

    public function get_settings_sections()
    {
        $sections = [];

        if (!empty(apply_filters('ds_suit/settings/modules', []))) {
            $sections[] = [
                'id' => $this->settings_prefix . 'modules',
                'title' => __('Modules', 'ds-suit'),
                'desc' => __('Here you can enable and disable modules. If disabled, a module will no longer be available in the Divi Builder.'),
            ];
        }

        if (!empty(apply_filters('ds_suit/settings/extensions', []))) {
            $sections[] = [
                'id' => $this->settings_prefix . 'extensions',
                'title' => __('Extensions', 'ds-suit'),
                'desc' => __('Here you can enable and disable extensions. Extensions are adding new functionality to existing modules and functions. If you disable a extension, it will no longer be available and previously made configurations will be ignored.', 'ds-suit'),
            ];
        }

        if (!empty(apply_filters('ds_suit/settings/widgets', []))) {
            $sections[] = [
                'id' => $this->settings_prefix . 'widgets',
                'title' => __('Widgets', 'ds-suit'),
                'desc' => __('Here you can enable and disable widgets. Widgets are adding new functionality to your sidebar and other widget areas. If you disable a widget, it will no longer be available. You can find widgets under Appearance > Widgets.', 'ds-suit'),
            ];
        }

        return $sections;
    }

    /**
     * Gets the settings fields
     *
     * @since 1.8.0
     *
     * @access public
     */

    public function get_settings_fields()
    {
        $fields = [];

        $sections = $this->get_settings_sections();

        foreach ($sections as $section) {
            if ($this->settings_api->is_tab_linked($section)) {
                continue;
            }

            $fields[$section['id']] = call_user_func(array($this, 'get_' . str_replace($this->settings_prefix, '', $section['id']) . '_fields'));
        }

        return $fields;
    }

    /**
     * Returns current page title
     *
     * @since 1.8.0
     *
     * @access protected
     */
    protected function get_modules_fields()
    {
        //module_slug => module_name
        // $modules = [
        //     'dss_library_layout' => esc_html__('Library Layout', 'ds-suit'),
        //     'dss_post_button' => esc_html__('Post Button', 'ds-suit'),
        //     'dss_post_excerpt' => esc_html__('Post Excerpt', 'ds-suit'),
        //     'dss_post_featured_image' => esc_html__('Post Featured Image', 'ds-suit'),
        //     'dss_post_title' => esc_html__('Post Title', 'ds-suit'),
        //     'dss_footer' => esc_html__('Footer', 'ds-suit'),
        //     'dss_bucket' => esc_html__('Bucket', 'ds-suit'),
        //     'dss_video_lightbox' => esc_html__('VideoLightbox', 'ds-suit'),

        //     'post_meta' => esc_html__('Post Meta', 'ds-suit'), //Special because Parent/Child module
        // ];

        $modules = [];
        $modules = apply_filters('ds_suit/settings/modules', $modules);

        asort($modules);

        $fields = [];

        foreach ($modules as $module_id => $module_name) {
            $fields[] = [
                'name' => 'enable_' . $module_id,
                'label' => $module_name,
                'desc' => __('Enable', 'ds-suit'),
                'type' => 'checkbox',
                'default' => 'on',
            ];
        }

        return $fields;
    }

    protected function get_extensions_fields()
    {
        $extensions = [];
        $extensions = apply_filters('ds_suit/settings/extensions', $extensions);

        asort($extensions);

        $fields = [];
        foreach ($extensions as $extension_id => $extension) {
            $fields[] = [
                'name' => 'enable_' . $extension_id,
                'label' => $extension['label'],
                'desc' => __('Enable', 'ds-suit'),
                'type' => 'checkbox',
                'default' => 'on',
                'note' => $extension['note'],
            ];
        }

        return $fields;
    }

    protected function get_widgets_fields()
    {
        $widgets = [];
        $widgets = apply_filters('ds_suit/settings/widgets', $widgets);

        asort($widgets);

        $fields = [];
        foreach ($widgets as $widget_id => $widget) {
            $fields[] = [
                'name' => 'enable_widget_' . $widget_id,
                'label' => $widget['label'],
                'desc' => __('Enable', 'ds-suit'),
                'type' => 'checkbox',
                'default' => 'on',
                'note' => $widget['note'],
            ];
        }

        return $fields;
    }

    protected function get_advanced_fields()
    {
        $fields = [];

        // if (jt_revolution_for_elementor()->is__premium_only()) {
        //     $fields[] = [
        //         'name' => 'enable_taxonomy_related',
        //         'label' => __('Taxonomy Related Content', 'ds-suit'),
        //         'desc' => __('When enabled, Revolution for Elementor adds a new post type "Taxonomy Related". This post type lets you define layouts which you can inject into posts, based on the posts terms, using the Taxonomy Related widget.', 'ds-suit'),
        //         'type' => 'radio',
        //         'default' => 'yes',
        //         'options' => [
        //             'yes' => __('Yes', 'ds-suit'),
        //             'no' => __('No', 'ds-suit'),
        //         ],
        //     ];
        // }

        return $fields;
    }

    /**
     * Returns current page title
     *
     * @since 1.8.0
     *
     * @access protected
     */

    protected function get_page_title()
    {
        return __('Battle Suit for Divi', 'ds-suit');
    }
}

// initialize
new Settings();
