(function ($) {
    'use strict';

	/**
	 * All of the code for your admin-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */

    window.localStorage.clear();


    $(document).ready(function () {

        $(".price-list-wrapper").on("change", "input[type=radio][name=price-model]", function(){
            let radio = $(this);
            console.log("Ich bin ein Radio", radio.attr("id"));
            let id = radio.attr("id");

            $(".price-list-wrapper .price-lists").hide();
            $(".price-list-wrapper #price-lists-"+id).show();
        });

        $(".price-list-wrapper").on("click", ".purchase", function(e){

            let plan_id = $(this).data("plan_id");
            let licenses = $('.price-list-wrapper form fieldset input[type=radio]:checked').val();
            console.log("Purchasing Plan " + plan_id + " times " + licenses);

            var handler = FS.Checkout.configure({
                plugin_id:  '2000',
                plan_id:    plan_id,
                public_key: 'pk_734437bab03d2e9a38449251581cc',
                image:      window.ds_suit_admin.divi_sensei_100
            });
            
            
            

            handler.open({
                name     : 'Divi Sensei Suit Bundle',
                licenses : licenses,
                // You can consume the response for after purchase logic.
                purchaseCompleted  : function (response) {
                    // The logic here will be executed immediately after the purchase confirmation.                                
                    // alert(response.user.email);
                },
                success  : function (response) {
                    // The logic here will be executed after the customer closes the checkout, after a successful purchase.                                
                    // alert(response.user.email);
                }
            });
            e.preventDefault();
        });

        $(".price-list-wrapper input#single").click();
        $(".price-list-wrapper").css("display", "block");
        





        //Image upload handler for Blurb widget
        $(document).on("click", ".upload_image_button", function (e) {
            e.preventDefault();
            var $button = $(this);

            // Create the media frame.
            var file_frame = wp.media.frames.file_frame = wp.media({
                title: 'Select or upload image',
                library: { // remove these to show all
                    type: 'image' // specific mime
                },
                button: {
                    text: 'Select'
                },
                multiple: false  // Set to true to allow multiple files to be selected
            });

            // When an image is selected, run a callback.
            file_frame.on('select', function () {
                // We set multiple to false so only get one image from the uploader

                var attachment = file_frame.state().get('selection').first().toJSON();

                $button.siblings('input').val(attachment.url);
                $button.siblings('input').change();
            });

            // Finally, open the modal
            file_frame.open();
        });
    });

})(jQuery);
